//
//  SupplierOrderDetailsViewController.swift
//  We1lAdmin
//
//  Created by omar altayyan on 10/31/18.
//  Copyright © 2018 juger. All rights reserved.
//

import Autotech


class SupplierOrderDetailsViewController
: ATEntityViewVC, UITableViewDelegate, UITableViewDataSource
{
    
    @IBOutlet weak var tableView: UITableView!
    
    @IBOutlet weak var dateValueLabel: UILabel!
    
    @IBOutlet weak var reasonValueLabel: UILabel!
    
    @IBOutlet weak var accountValueLabel: UILabel!
    
    override func getTableViews() -> Array<UITableView> {
        return [self.tableView]
    }
    override open func useGlobalImageBackground() -> Bool
    {
        return true
    }
    
    override func fillFromDictionary(_ dataDictionary: NSDictionary) {
        
        self.accountValueLabel.text = getJsonDictionaryStringValue(dataDictionary, "Account")
        
        self.reasonValueLabel.text = getJsonDictionaryStringValue(dataDictionary, "Reason")
        
        
        self.dateValueLabel.text = getJsonDictionaryDateValue(dataDictionary, "AddDateTime")
        
        self.title = getJsonDictionaryStringValue(dataDictionary, "Supplier")
    }
    override func viewDidLoad() {
        super.viewDidLoad()
        tableView.delegate = self
        tableView.dataSource = self
    }
    
    func productsArray() -> NSArray
    {
        if let value = (dataToView["Bodies"] as? NSArray)
        {
            return value
        }
        return []
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return productsArray().count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        let cell = tableView.dequeueReusableCell(withIdentifier:"supplierOrdersDetailsCell", for: indexPath) as! SupplierOrderDetailsTableCell
        
        let dataElement = productsArray()[indexPath.item] as! NSDictionary

        
        cell.fillFromDictionary(dataElement)
        
        return cell
    }
    
}
